//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2021 BY HOLTEK SEMICONDUCTOR INC
//  File Name : ANALOG.h
// Description: ANALOG 
//Targer Board: None
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 20210308
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________


#ifndef _Pump_Value_H_
#define _Pump_Value_H_

extern	__16_type	gu16v_pwm_buff;
extern	__16_type	gu16v_pwm_target;

#define	HARDWARE_VERSION X802



#define	BHMB3006	1
#define	X802		2
#define	B02			3
void STP_PUMP_ON();
void STP_PUMP_OFF();
void STP_VALUE_ON();
void STP_VALUE_OFF();
void PWM_TEST();




											
#define STM0A_MAX			1023      		
											
#define STM0AL_Default		767%256			
#define STM0AH_Default		767/256       	// 
#define STM0RP_Default		4       	  	//


#define TM2AL_bat_60		580%256	
#define TM2AH_bat_60		580/256  
#define TM2AL_bat_58		630%256	
#define TM2AH_bat_58		630/256    
#define TM2AL_bat_56		680%256
#define TM2AH_bat_56		680/256    
#define TM2AL_bat_54		730%256	
#define TM2AH_bat_54		730/256      
#define TM2AL_bat_52		780%256	
#define TM2AH_bat_52		780/256   
#define TM2AL_bat_50		830%256	
#define TM2AH_bat_50		830/256    
#define TM2AL_bat_48		880%256	
#define TM2AH_bat_48		880/256      
#define TM2AL_bat_46		930%256	
#define TM2AH_bat_46		930/256   
#define TM2AL_bat_44		980%256	
#define TM2AH_bat_44		980/256  


#if	HARDWARE_VERSION==BHMB3006
#define	GPIO_VALUE_IO 	_pac1
#define	GPIO_VALUE 		_pa1
#define	GPIO_PUMP_IO 	_pac5
#define	GPIO_PUMP 		_pa5
#define	SET_PUMP_ON()	{_pas13 = 0;_pas12 = 1;	_ston = 1;	}
#define	SET_PUMP_OFF()	{_pas13 = 0;_pas12 = 0;	GPIO_PUMP_IO = 0;GPIO_PUMP = 0;_ston = 0;}
#define	SET_VALUE_ON()	{_pas03 = 0;_pas02 = 0;	GPIO_VALUE = 1;}
#define	SET_VALUE_OFF()	{_pas03 = 0;_pas02 = 0;	GPIO_VALUE = 0;}
#define STM0C0_Default		0b00000000   	// CLOCK  fSYS
#define STM0C1_Default		0B10100000		
#endif	

#if	HARDWARE_VERSION==X802
#define	GPIO_VALUE_IO 	_pcc3
#define	GPIO_VALUE 		_pc3
#define	GPIO_PUMP_IO 	_pac6
#define	GPIO_PUMP 		_pa6
#define	SET_PUMP_ON()	{_pas15 = 0;_pas14 = 1;	_ston = 1;	}
#define	SET_PUMP_OFF()	{_pas15 = 0;_pas14 = 0;	GPIO_PUMP_IO = 0;GPIO_PUMP = 0;_ston = 0;}
#define	SET_VALUE_ON()	{_pcs07 = 0;_pcs06 = 0;	GPIO_VALUE = 1;GPIO_VALUE_IO = 0;}
#define	SET_VALUE_OFF()	{_pcs07 = 0;_pcs06 = 0;	GPIO_VALUE = 0;GPIO_VALUE_IO = 0;}
#define STM0C0_Default		0b00000000   	// CLOCK  fSYS
#define STM0C1_Default		0B10100100		
#endif

#if	HARDWARE_VERSION==B02
#define	GPIO_VALUE_IO 	_pcc2
#define	GPIO_VALUE 		_pc2
#define	GPIO_PUMP_IO 	_pac5
#define	GPIO_PUMP 		_pa5
#define	SET_PUMP_ON()	{_pas13 = 0;_pas12 = 1;	_ston = 1;	}
#define	SET_PUMP_OFF()	{_pas13 = 0;_pas12 = 0;	GPIO_PUMP_IO = 0;GPIO_PUMP = 1;_ston = 0;}
#define	SET_VALUE_ON()	{_pcs05 = 0;_pcs04 = 0;	GPIO_VALUE = 1;GPIO_VALUE_IO = 0;}
#define	SET_VALUE_OFF()	{_pcs05 = 0;_pcs04 = 0;	GPIO_VALUE = 0;GPIO_VALUE_IO = 0;}
#define STM0C0_Default		0b00000000   	// CLOCK  fSYS
#define STM0C1_Default		0B10100100		
#endif

#endif

